/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Map;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncLaserSideConfig {
    private BlockPos pos;
    private CompoundTag sideConfig;

    public SyncLaserSideConfig() {
    }

    public SyncLaserSideConfig(BlockPos pos, Map<Direction, Boolean> sideConfig) {
        this.pos = pos;
        this.sideConfig = LaserBlockBlockEntity.saveSideConfig(sideConfig);
    }

    public SyncLaserSideConfig(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.sideConfig = buf.m_130260_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.sideConfig);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        LaserBlockBlockEntity be;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.m_8055_(this.pos);
            be.applyNewSideConfig(LaserBlockBlockEntity.loadSideConfig(this.sideConfig), (Player)player);
            level.m_7260_(this.pos, state, state, 2);
        }
    }
}

