/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class LowercasedEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> Component.m_237110_((String)"commands.forge.arguments.enum.invalid", (Object[])new Object[]{constants, found}));
    private final Class<T> enumClass;

    public static <R extends Enum<R>> LowercasedEnumArgument<R> enumArgument(Class<R> enumClass) {
        return new LowercasedEnumArgument<R>(enumClass);
    }

    private LowercasedEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name.toLowerCase(Locale.ENGLISH), (Object)Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this::toLowercasedEnumName).toArray()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(this::toLowercasedEnumName), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(this::toLowercasedEnumName).toList();
    }

    private String toLowercasedEnumName(Enum<?> theEnum) {
        return theEnum.name().toLowerCase(Locale.ENGLISH);
    }

    public static class Info<T extends Enum<T>>
    implements ArgumentTypeInfo<LowercasedEnumArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.m_130070_(template.enumClass.getName());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            try {
                return new Template(Class.forName(buffer.m_130277_()));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("enum", template.enumClass.getName());
        }

        public Template unpack(LowercasedEnumArgument<T> argument) {
            return new Template(argument.enumClass);
        }

        public class Template
        implements ArgumentTypeInfo.Template<LowercasedEnumArgument<T>> {
            final Class<T> enumClass;

            Template(Class<T> enumClass) {
                this.enumClass = enumClass;
            }

            public LowercasedEnumArgument<T> instantiate(CommandBuildContext ctx) {
                return new LowercasedEnumArgument(this.enumClass);
            }

            public ArgumentTypeInfo<LowercasedEnumArgument<T>, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

