/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedHopperBlock
extends HopperBlock
implements IReinforcedBlock,
IOverlayDisplay,
IDisguisable {
    public ReinforcedHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedHopperBlockEntity be;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ReinforcedHopperBlockEntity && ((be = (ReinforcedHopperBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            player.m_5893_((MenuProvider)be);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ReinforcedHopperBlockEntity) {
            ReinforcedHopperBlockEntity be = (ReinforcedHopperBlockEntity)blockEntity;
            if (isMoving) {
                be.m_6211_();
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReinforcedHopperBlockEntity) {
            ReinforcedHopperBlockEntity be = (ReinforcedHopperBlockEntity)blockEntity;
            HopperBlockEntity.m_155567_((Level)level, (BlockPos)pos, (BlockState)state, (Entity)entity, (HopperBlockEntity)be);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedHopperBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ReinforcedHopperBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get()), HopperBlockEntity::m_155573_);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50332_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(level, pos);
        }
        return super.m_7749_(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).m_41720_() == this.m_5456_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getDisguisedStack(level, pos);
    }

    public static class ExtractionBlock
    implements IExtractionBlock {
        @Override
        public boolean canExtract(IOwnable ownable, Level level, BlockPos pos, BlockState state) {
            ReinforcedHopperBlockEntity hopperBe = (ReinforcedHopperBlockEntity)level.m_7702_(pos);
            if (!hopperBe.getOwner().isValidated()) {
                return false;
            }
            if (!ownable.getOwner().owns(hopperBe)) {
                if (ownable instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)((Object)ownable);
                    return inv.isAllowed(hopperBe.getOwner().getName());
                }
                return false;
            }
            return true;
        }

        @Override
        public Block getBlock() {
            return (Block)SCContent.REINFORCED_HOPPER.get();
        }
    }
}

