/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.blocks.KeyPanelBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyPanelBlockEntity
extends CustomizableBlockEntity
implements IPasscodeProtected,
ILockable {
    private byte[] passcode;
    private UUID saltKey;
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;

    public KeyPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEY_PANEL_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        long cooldownLeft;
        super.m_183515_(tag);
        if (this.saltKey != null) {
            tag.m_128362_("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.m_128359_("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        tag.m_128356_("cooldownLeft", (cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis()) <= 0L ? -1L : cooldownLeft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
        if (tag.m_128441_("sendMessage") && !tag.m_128471_("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeyPanelBlock) {
            KeyPanelBlock block2 = (KeyPanelBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.m_58900_().m_61143_((Property)AbstractPanelBlock.POWERED) == false && IPasscodeProtected.super.shouldAttemptCodebreak(player);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled && ((Boolean)((Option.BooleanOption)option).get()).booleanValue() || option == this.signalLength) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AbstractPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, this.m_58900_().m_60734_());
        }
        super.onOptionChanged(option);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)AbstractPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        level.m_46672_(pos, state.m_60734_());
        level.m_46672_(pos.m_121945_(AbstractPanelBlock.getConnectedDirection(state).m_122424_()), state.m_60734_());
        SaltData.removeSalt(this.getSaltKey());
        this.passcode = null;
        this.saltKey = null;
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.m_6596_();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

